/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import oracle.install.commons.flow.AbstractFlowExecutor;
import oracle.install.commons.flow.FlowNavigator;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.State;
import oracle.install.commons.util.Graph;
import oracle.install.commons.util.exception.ExceptionManager;

public class DefaultFlowNavigator
implements FlowNavigator {
    private Object lock = new Object();
    private AbstractFlowExecutor flowExecutor;

    public DefaultFlowNavigator(AbstractFlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    @Override
    public RoutePlan getRoutePlan() {
        return this.flowExecutor.getRoutePlan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goBackward() {
        Object object = this.lock;
        synchronized (object) {
            ExceptionManager exceptionManager = ExceptionManager.getInstance();
            try {
                this.flowExecutor.previousViewState();
            }
            catch (Throwable exception) {
                exceptionManager.handleException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goForward() {
        Object object = this.lock;
        synchronized (object) {
            ExceptionManager exceptionManager = ExceptionManager.getInstance();
            RoutePlan routePlan = this.flowExecutor.getFlowContext().getRoutePlan();
            Graph<Route, State> currentVertex = routePlan.getCurrentVertex();
            if (!currentVertex.isTerminal()) {
                try {
                    this.flowExecutor.nextViewState();
                }
                catch (Throwable exception) {
                    exceptionManager.handleException(exception);
                }
            }
        }
    }

    @Override
    public void moveTo(Graph<Route, State> node) {
        ExceptionManager exceptionManager = ExceptionManager.getInstance();
        try {
            this.flowExecutor.moveTo(node);
        }
        catch (Throwable exception) {
            exceptionManager.handleException(exception);
        }
    }

    @Override
    public void reset() {
        ExceptionManager exceptionManager = ExceptionManager.getInstance();
        try {
            this.flowExecutor.nextViewState();
        }
        catch (Throwable exception) {
            exceptionManager.handleException(exception);
        }
    }
}

